#pragma once

#include <afxtempl.h>
#include "stdafx.h"
#include "FileDB.h"

///////////////////////////////////////////////////////////////////////////////
#define kPhbFolder						"PhoneBooks"
#define	kPhbFilePrefix					"Phb"

#define	kPhbSettingsKey					"Settings"
#define	kPhbStatusKey					"Status"
#define	kPhbWriteProtectedKey			"WriteProtected"
#define	kPhbTotalEntriesKey				"TotalEntries"
#define	kPhbNumEntriesKey				"UsedEntries"
#define	kPhbEntryNameKey				"Name"
#define	kPhbEntryPhoneNumberKey			"Tel"
#define	kPhbEntryCharSetKey				"CharSet"

#define kPhbFirstIndex					1     //Must be greater than 0 (zero)
///////////////////////////////////////////////////////////////////////////////
class CPHBEntry
{
private:
	CString			mName, mTel;
    int				mCharSet;
public:
	CPHBEntry(CString iName, int iCharSet, CString iTel)	{ mName=iName; mCharSet=iCharSet; mTel=iTel; };
	CPHBEntry(void)								{ };
	virtual ~CPHBEntry(void)					{ };
	// GET
	virtual CString	GetName()					{ return mName; };
	virtual int		GetCharSet()				{ return mCharSet; };
	virtual CString GetTel()					{ return mTel; };
	// SET
	virtual void 	SetName(CString iName)		{ mName=iName; };
	virtual void 	SetCharSet(int iCharSet)	{ mCharSet=iCharSet; };
	virtual void 	SetTel(CString iTel)		{ mTel=iTel; };
};
///////////////////////////////////////////////////////////////////////////////
class CPhoneBook
{
private:
	CString		mName;	
	CFileDB*	mFile;
	bool		mStatus;
	bool		mWriteProtected;
	int			mTotalEntries;
	int			mUsedEntries;
	CArray<CPHBEntry*,CPHBEntry*&> mEntryArray;
public:
	CPhoneBook(void);
	CPhoneBook(CString iName);
	virtual ~CPhoneBook(void);
	// Load PhoneBook param and entries
	virtual void		Load();
	// Save PhoneBook param and entries
	virtual void		Save();
	virtual CArray<CPHBEntry*,CPHBEntry*&>* GetEntryArray();
	virtual bool 		AddEntry(CString iName, int iCharSet, CString iTel, BOOL iForced=FALSE);
	virtual bool 		AddEntry(int iIndex, CString iName, int iCharSet, CString iTel, BOOL iForced=FALSE);
	virtual void 		DeleteEntry(int iIndex, BOOL iShift=FALSE);
	virtual void 		DeleteEntries();
	virtual bool 		FindName(CString iName);
	virtual bool 		FindNumber(CString iNumber);
	virtual bool		AddEntryInFirstPlace(CString iName, int iCharSet, CString iTel, BOOL iForced=FALSE);
	//GET
	virtual CPHBEntry*	GetEntry(int iIndex);
	virtual int			GetFirstFreeIndex();
	virtual CString		GetName()							{ return mName; };
	virtual bool		GetStatus()							{ return mStatus; };
	virtual bool		IsWriteProtected()					{ return mWriteProtected; };
	virtual int			GetTotalEntries()					{ return mTotalEntries; };
	virtual int			GetUsedEntries();
	//SET
	virtual void 		SetName(CString iName)				{ mName=iName; };
	virtual void 		SetStatus(bool iStatus)				{ mStatus=iStatus; };
	virtual void 		SetWriteProtected(bool iProtec)		{ mWriteProtected=iProtec; };
    virtual void 		SetTotalEntries(int iNb)			{ mTotalEntries=iNb; };	
	virtual void 		SetUsedEntries(int iNb)				{ mUsedEntries=iNb; };
	// OTHER
	virtual void		CheckLength(int iLength);	
};
